<?php

namespace App\Classes;

use Illuminate\Support\Facades\DB;

class GoBizUpdater820
{
    public function runUpdate()
    {
        // Check "toyyibpay_mode" column exists
        $toyyibpayModeExists = DB::table('config')->where('id', 55)->exists();
        if (!$toyyibpayModeExists) {
            DB::statement("INSERT INTO `config` (`config_key`, `config_value`) VALUES ('toyyibpay_mode', 'live')");
        }

        DB::statement("ALTER TABLE `plans` ADD `custom_domain` BOOLEAN NOT NULL DEFAULT FALSE AFTER `appointment`");
        DB::statement("ALTER TABLE `business_cards` ADD `custom_domain` TEXT NULL AFTER `card_url`");

        // Check "currency_format_type" column exists
        $currencyFormatTypeExists = DB::table('config')->where('id', 56)->exists();
        if (!$currencyFormatTypeExists) {
            DB::statement("INSERT INTO `config` (`config_key`, `config_value`) VALUES ('currency_format_type', '1,234,567.89')");
        }

        // Check "currency_decimals_place" column exists
        $currencyDecimalsPlaceExists = DB::table('config')->where('id', 57)->exists();
        if (!$currencyDecimalsPlaceExists) {
            DB::statement("INSERT INTO `config` (`config_key`, `config_value`) VALUES ('currency_decimals_place', '2')");
        }

        DB::statement("CREATE TABLE `custom_domain_requests` (
        `id` int UNSIGNED NOT NULL,
        `custom_domain_request_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
        `user_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
        `card_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
        `previous_domain` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
        `current_domain` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
        `transfer_status` int NOT NULL DEFAULT '0',
        `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
        `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
        `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");

        DB::statement("ALTER TABLE `custom_domain_requests` ADD PRIMARY KEY (`id`)");

        DB::statement("ALTER TABLE `custom_domain_requests` MODIFY `id` int UNSIGNED NOT NULL AUTO_INCREMENT");
    }
}
